﻿Unit Unit1;

interface

uses System, System.Drawing, System.Windows.Forms;

type
  Form1 = class(Form)
    procedure Form1_Load(sender: Object; e: EventArgs);
    procedure pictureBox1_MouseDown(sender: Object; e: MouseEventArgs);
    procedure pictureBox1_MouseUp(sender: Object; e: MouseEventArgs);
    procedure pictureBox1_MouseMove(sender: Object; e: MouseEventArgs);
    procedure numericUpDown1_ValueChanged(sender: Object; e: EventArgs);
    procedure toolStripMenuItem4_Click(sender: Object; e: EventArgs);
    procedure toolStripMenuItem5_Click(sender: Object; e: EventArgs);
    procedure button1_Click(sender: Object; e: EventArgs);
    procedure button2_Click(sender: Object; e: EventArgs);
    procedure toolStripMenuItem3_Click(sender: Object; e: EventArgs);
    procedure toolStripMenuItem6_Click(sender: Object; e: EventArgs);
    procedure toolStripMenuItem8_Click(sender: Object; e: EventArgs);
    procedure toolStripMenuItem9_Click(sender: Object; e: EventArgs);
  {$region FormDesigner}
  internal
    {$resource Unit1.Form1.resources}
    pictureBox1: PictureBox;
    panel1: Panel;
    panel2: Panel;
    button1: Button;
    button2: Button;
    colorDialog1: ColorDialog;
    numericUpDown1: NumericUpDown;
    menuStrip1: MenuStrip;
    toolStripMenuItem1: ToolStripMenuItem;
    toolStripMenuItem3: ToolStripMenuItem;
    toolStripMenuItem4: ToolStripMenuItem;
    toolStripMenuItem5: ToolStripMenuItem;
    toolStripMenuItem6: ToolStripMenuItem;
    toolStripMenuItem2: ToolStripMenuItem;
    toolStripMenuItem8: ToolStripMenuItem;
    toolStripMenuItem9: ToolStripMenuItem;
    openFileDialog1: OpenFileDialog;
    saveFileDialog1: SaveFileDialog;
    {$include Unit1.Form1.inc}
  {$endregion FormDesigner}
  public
    constructor;
    begin
      InitializeComponent;
    end;
  end;

implementation

var gr: Graphics;
bm: Bitmap;
p_c: Pen;
s_b: SolidBrush;
c_f, c_b: Color;
w: decimal;
x1, y1, x2, y2: integer;
m_d: boolean;
F_N: string;

procedure Form1.Form1_Load(sender: Object; e: EventArgs);
begin
  bm:=new Bitmap(pictureBox1.Width, pictureBox1.Height);
  pictureBox1.Image:=(Image) (bm);
  gr:=Graphics.FromImage(pictureBox1.Image);
  gr.Clear(Color.White);
  gr:=pictureBox1.CreateGraphics;
  c_f:=Color.Black;
  p_c:=new Pen(c_f, 1);
  c_b:=Color.White;
  s_b:=new SolidBrush(c_b);
end;

procedure Form1.pictureBox1_MouseDown(sender: Object; e: MouseEventArgs);
begin
  m_d:=true;
  x1:=e.X; y1:=e.Y;
end;

procedure Form1.pictureBox1_MouseUp(sender: Object; e: MouseEventArgs);
begin
  m_d:=false;
end;

procedure Form1.pictureBox1_MouseMove(sender: Object; e: MouseEventArgs);
begin
  if m_d then
  begin
    gr.DrawLine(p_c, x1, y1, e.X, e.Y);
  end;
  x1:=e.X; y1:=e.Y;
end;

procedure Form1.numericUpDown1_ValueChanged(sender: Object; e: EventArgs);
begin
  p_c.Dispose;
  w:=numericUpDown1.Value;
  p_c:=new Pen(c_f, (integer) (w));
end;

procedure Form1.toolStripMenuItem4_Click(sender: Object; e: EventArgs);
begin
  openFileDialog1.ShowDialog();
  F_N:=openFileDialog1.FileName;
  Text:='myPaint'+F_N;
  PictureBox1.Load(F_N);
end;

procedure Form1.toolStripMenuItem5_Click(sender: Object; e: EventArgs);
begin
  saveFileDialog1.ShowDialog();
  F_N:=saveFileDialog1.FileName;
  PictureBox1.Image.save(F_N);
  Text:='myPaint'+F_N;
end;

procedure Form1.button1_Click(sender: Object; e: EventArgs);
begin
  colorDialog1.ShowDialog();
  c_f:=colorDialog1.Color;
  w:=numericUpDown1.Value;
  p_c.Dispose;
  p_c:=new Pen(c_f, (integer) (w));
  panel1.BackColor:=c_f;
end;

procedure Form1.button2_Click(sender: Object; e: EventArgs);
begin
  colorDialog1.ShowDialog();
  c_b:=colorDialog1.Color;
  s_b.Dispose;
  s_b:=new SolidBrush(c_b);;
  panel2.BackColor:=c_b;
end;

procedure Form1.toolStripMenuItem3_Click(sender: Object; e: EventArgs);
begin
  gr:=pictureBox1.CreateGraphics;
  gr.Clear(c_b);
end;

procedure Form1.toolStripMenuItem6_Click(sender: Object; e: EventArgs);
begin
  close;
end;

procedure Form1.toolStripMenuItem8_Click(sender: Object; e: EventArgs);
begin
  colorDialog1.ShowDialog();
  c_f:=colorDialog1.Color;
  w:=numericUpDown1.Value;
  p_c.Dispose;
  p_c:=new Pen(c_f, (integer) (w));
  panel1.BackColor:=c_f;
end;

procedure Form1.toolStripMenuItem9_Click(sender: Object; e: EventArgs);
begin
  colorDialog1.ShowDialog();
  c_b:=colorDialog1.Color;
  s_b.Dispose;
  s_b:=new SolidBrush(c_b);;
  panel2.BackColor:=c_b;
end;

end.
